/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.OrderedMap;

public class PixmapPacker
implements Disposable {
    private static final boolean debug = false;
    private static final String ANONYMOUS = "ANONYMOUS";
    final int pageWidth;
    final int pageHeight;
    final Pixmap.Format pageFormat;
    final int padding;
    final boolean duplicateBorder;
    final Array<Page> pages = new Array();
    Page current;
    boolean packToTexture;
    boolean disposed;

    public PixmapPacker(int pageWidth, int pageHeight, Pixmap.Format pageFormat, int padding2, boolean duplicateBorder) {
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.pageFormat = pageFormat;
        this.padding = padding2;
        this.duplicateBorder = duplicateBorder;
        this.newPage();
    }

    public synchronized Rectangle pack(Pixmap image) {
        return this.pack(null, image);
    }

    public synchronized Rectangle pack(String name, Pixmap image) {
        if (this.disposed) {
            return null;
        }
        if (name != null && this.getRect(name) != null) {
            throw new GdxRuntimeException("Pixmap has already been packed with name: " + name);
        }
        int borderPixels = this.padding + (this.duplicateBorder ? 1 : 0) << 1;
        Rectangle rect = new Rectangle(0.0f, 0.0f, image.getWidth() + borderPixels, image.getHeight() + borderPixels);
        if (rect.getWidth() > (float)this.pageWidth || rect.getHeight() > (float)this.pageHeight) {
            if (name == null) {
                throw new GdxRuntimeException("Page size too small for anonymous pixmap.");
            }
            throw new GdxRuntimeException("Page size too small for pixmap: " + name);
        }
        Node node = this.insert(this.current.root, rect);
        if (node == null) {
            this.newPage();
            return this.pack(name, image);
        }
        node.leafName = name == null ? ANONYMOUS : name;
        rect = new Rectangle(node.rect);
        rect.width -= (float)borderPixels;
        rect.height -= (float)borderPixels;
        rect.x += (float)(borderPixels >>= 1);
        rect.y += (float)borderPixels;
        if (name != null) {
            this.current.rects.put(name, rect);
            this.current.addedRects.add(name);
        }
        int rectX = (int)rect.x;
        int rectY = (int)rect.y;
        int rectWidth = (int)rect.width;
        int rectHeight = (int)rect.height;
        if (this.packToTexture && !this.duplicateBorder && this.current.texture != null && !this.current.dirty) {
            this.current.texture.bind();
            Gdx.gl.glTexSubImage2D(this.current.texture.glTarget, 0, rectX, rectY, rectWidth, rectHeight, image.getGLFormat(), image.getGLType(), image.getPixels());
        } else {
            this.current.dirty = true;
        }
        Pixmap.Blending blending = Pixmap.getBlending();
        Pixmap.setBlending(Pixmap.Blending.None);
        this.current.image.drawPixmap(image, rectX, rectY);
        if (this.duplicateBorder) {
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            this.current.image.drawPixmap(image, 0, 0, 1, 1, rectX - 1, rectY - 1, 1, 1);
            this.current.image.drawPixmap(image, imageWidth - 1, 0, 1, 1, rectX + rectWidth, rectY - 1, 1, 1);
            this.current.image.drawPixmap(image, 0, imageHeight - 1, 1, 1, rectX - 1, rectY + rectHeight, 1, 1);
            this.current.image.drawPixmap(image, imageWidth - 1, imageHeight - 1, 1, 1, rectX + rectWidth, rectY + rectHeight, 1, 1);
            this.current.image.drawPixmap(image, 0, 0, imageWidth, 1, rectX, rectY - 1, rectWidth, 1);
            this.current.image.drawPixmap(image, 0, imageHeight - 1, imageWidth, 1, rectX, rectY + rectHeight, rectWidth, 1);
            this.current.image.drawPixmap(image, 0, 0, 1, imageHeight, rectX - 1, rectY, 1, rectHeight);
            this.current.image.drawPixmap(image, imageWidth - 1, 0, 1, imageHeight, rectX + rectWidth, rectY, 1, rectHeight);
        }
        Pixmap.setBlending(blending);
        return rect;
    }

    private void newPage() {
        Page page = new Page();
        page.image = new Pixmap(this.pageWidth, this.pageHeight, this.pageFormat);
        page.root = new Node(0, 0, this.pageWidth, this.pageHeight, null, null, null);
        page.rects = new OrderedMap();
        this.pages.add(page);
        this.current = page;
    }

    private Node insert(Node node, Rectangle rect) {
        if (node.leafName == null && node.leftChild != null && node.rightChild != null) {
            Node newNode = this.insert(node.leftChild, rect);
            if (newNode == null) {
                newNode = this.insert(node.rightChild, rect);
            }
            return newNode;
        }
        if (node.leafName != null) {
            return null;
        }
        if (node.rect.width == rect.width && node.rect.height == rect.height) {
            return node;
        }
        if (node.rect.width < rect.width || node.rect.height < rect.height) {
            return null;
        }
        node.leftChild = new Node();
        node.rightChild = new Node();
        int deltaWidth = (int)node.rect.width - (int)rect.width;
        int deltaHeight = (int)node.rect.height - (int)rect.height;
        if (deltaWidth > deltaHeight) {
            node.leftChild.rect.x = node.rect.x;
            node.leftChild.rect.y = node.rect.y;
            node.leftChild.rect.width = rect.width;
            node.leftChild.rect.height = node.rect.height;
            node.rightChild.rect.x = node.rect.x + rect.width;
            node.rightChild.rect.y = node.rect.y;
            node.rightChild.rect.width = node.rect.width - rect.width;
            node.rightChild.rect.height = node.rect.height;
        } else {
            node.leftChild.rect.x = node.rect.x;
            node.leftChild.rect.y = node.rect.y;
            node.leftChild.rect.width = node.rect.width;
            node.leftChild.rect.height = rect.height;
            node.rightChild.rect.x = node.rect.x;
            node.rightChild.rect.y = node.rect.y + rect.height;
            node.rightChild.rect.width = node.rect.width;
            node.rightChild.rect.height = node.rect.height - rect.height;
        }
        return this.insert(node.leftChild, rect);
    }

    public Array<Page> getPages() {
        return this.pages;
    }

    public synchronized Rectangle getRect(String name) {
        for (Page page : this.pages) {
            Rectangle rect = (Rectangle)page.rects.get(name);
            if (rect == null) continue;
            return rect;
        }
        return null;
    }

    public synchronized Page getPage(String name) {
        for (Page page : this.pages) {
            Rectangle rect = (Rectangle)page.rects.get(name);
            if (rect == null) continue;
            return page;
        }
        return null;
    }

    public synchronized int getPageIndex(String name) {
        for (int i = 0; i < this.pages.size; ++i) {
            Rectangle rect = (Rectangle)this.pages.get((int)i).rects.get(name);
            if (rect == null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized void dispose() {
        for (Page page : this.pages) {
            if (page.texture != null) continue;
            page.image.dispose();
        }
        this.disposed = true;
    }

    public synchronized TextureAtlas generateTextureAtlas(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        TextureAtlas atlas = new TextureAtlas();
        this.updateTextureAtlas(atlas, minFilter, magFilter, useMipMaps);
        return atlas;
    }

    public synchronized void updateTextureAtlas(TextureAtlas atlas, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        this.updatePageTextures(minFilter, magFilter, useMipMaps);
        for (Page page : this.pages) {
            if (page.addedRects.size <= 0) continue;
            for (String name : page.addedRects) {
                Rectangle rect = (Rectangle)page.rects.get(name);
                TextureRegion region = new TextureRegion(page.texture, (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
                atlas.addRegion(name, region);
            }
            page.addedRects.clear();
            atlas.getTextures().add(page.texture);
        }
    }

    public synchronized void updateTextureRegions(Array<TextureRegion> regions, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        this.updatePageTextures(minFilter, magFilter, useMipMaps);
        while (regions.size < this.pages.size) {
            regions.add(new TextureRegion(this.pages.get((int)regions.size).texture));
        }
    }

    public synchronized void updatePageTextures(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
        for (Page page : this.pages) {
            page.updateTexture(minFilter, magFilter, useMipMaps);
        }
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public int getPadding() {
        return this.padding;
    }

    public boolean getDuplicateBorder() {
        return this.duplicateBorder;
    }

    public boolean getPackToTexture() {
        return this.packToTexture;
    }

    public void setPackToTexture(boolean packToTexture) {
        this.packToTexture = packToTexture;
    }

    public static class Page {
        Node root;
        OrderedMap<String, Rectangle> rects;
        Pixmap image;
        Texture texture;
        final Array<String> addedRects = new Array();
        boolean dirty;

        public Pixmap getPixmap() {
            return this.image;
        }

        public OrderedMap<String, Rectangle> getRects() {
            return this.rects;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public boolean updateTexture(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean useMipMaps) {
            if (this.texture != null) {
                if (!this.dirty) {
                    return false;
                }
                this.texture.load(this.texture.getTextureData());
            } else {
                this.texture = new Texture(new PixmapTextureData(this.image, this.image.getFormat(), useMipMaps, false, true)){

                    @Override
                    public void dispose() {
                        super.dispose();
                        Page.this.image.dispose();
                    }
                };
                this.texture.setFilter(minFilter, magFilter);
            }
            this.dirty = false;
            return true;
        }
    }

    static final class Node {
        public Node leftChild;
        public Node rightChild;
        public Rectangle rect;
        public String leafName;

        public Node(int x, int y, int width, int height, Node leftChild, Node rightChild, String leafName) {
            this.rect = new Rectangle(x, y, width, height);
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.leafName = leafName;
        }

        public Node() {
            this.rect = new Rectangle();
        }
    }
}

